<?php
require_once('../../config.php');
require_once("{$CFG->libdir}/formslib.php");
require_once($CFG->libdir.'/adminlib.php');
require_once('forms.php');
require_once('locallib.php');

require_login();

require_capability('local/edlink:manageclients', context_system::instance());

admin_externalpage_setup('local_edlink_settings');

$action  = optional_param('action', '', PARAM_ALPHA);

echo $OUTPUT->header();

echo $OUTPUT->heading(get_string('pluginname', 'local_edlink'));

$view_table = false;
switch ($action) {
    case 'generate':
        $view_table = true;

        $record = new stdClass();
        $record->redirect_uri = 'https://ed.link/api/authentication/moodle https://ed.link/sso/administrator';
        $record->grant_types = 'authorization_code refresh_token';
        $record->scope = 'user_info';
        $record->user_id = '';

        $record->client_id = generate_secret();
        $record->client_secret = generate_secret(64);

        if (!$DB->insert_record('oauth_clients', $record)) {
            print_error('insert_error', 'local_edlink');
        }

        echo $OUTPUT->notification(get_string('saveok', 'local_edlink'), 'notifysuccess');

        break;
    case 'edit':
        $id = required_param('id', PARAM_TEXT);
        if (!$client_edit = $DB->get_record('oauth_clients', array('id' => $id))) {
            echo $OUTPUT->notification(get_string('client_not_exists', 'local_edlink'));
            $view_table = true;
            break;
        }
    case 'add':
        $bform = new local_edlink_clients_form();
        if ($bform->is_cancelled()) {
            $view_table = true;
            break;
        } else if ($fromform=$bform->get_data() and confirm_sesskey()) {
            //get values
            $record = new stdClass();
            $record->redirect_uri = $fromform->redirect_uri;
            $record->grant_types = $fromform->grant_types;
            $record->scope = $fromform->scope;
            $record->user_id = $fromform->user_id ? $fromform->user_id :'';

            //do save
            if (!isset($client_edit)) {
                $record->client_id = $fromform->client_id;
                $record->client_secret = generate_secret();
                if (!$DB->insert_record('oauth_clients', $record)) {
                    print_error('insert_error', 'local_edlink');
                }
            } else {
                $record->id = $client_edit->id;
                if (!$DB->update_record('oauth_clients', $record)) {
                    print_error('update_error', 'local_edlink');
                }
            }
            echo $OUTPUT->notification(get_string('saveok', 'local_edlink'), 'notifysuccess');
            $view_table = true;
            break;
        }

        $form = new stdClass();
        //set values
        if (isset($client_edit)) {
            $form->client_id           = $client_edit->client_id;
            $form->redirect_uri        = $client_edit->redirect_uri;
            $form->grant_types         = $client_edit->grant_types;
            $form->scope               = $client_edit->scope;
            $form->user_id             = $client_edit->user_id;
            $form->action              = 'edit';
        } else {
            $form->client_id            = "";
            $form->redirect_uri         = "";
            $form->grant_types          = "authorization_code refresh_token";
            $form->scope                = "user_info";
            $form->user_id              = "0";
            $form->action               = 'add';
        }
        $bform->set_data($form);
        $bform->display();

        break;
    case 'addwordpress':
        $bform = new local_edlink_clients_wp_form();
        if ($bform->is_cancelled()) {
            $view_table = true;
            break;
        } else if ($fromform=$bform->get_data() and confirm_sesskey()) {
            if (!oauth_add_wordpress_client($fromform->client_id, $fromform->url)) {
                print_error('insert_error', 'local_edlink');
            }
            echo $OUTPUT->notification(get_string('saveok', 'local_edlink'), 'notifysuccess');
            $view_table = true;
            break;
        }
        $bform->display();
        break;
    case 'addnodes':
        if (!oauth_add_wordpress_client('nodes', get_service_url('nodes'))) {
            print_error('insert_error', 'local_edlink');
        }
        echo $OUTPUT->notification(get_string('saveok', 'local_edlink'), 'notifysuccess');
        $view_table = true;
        break;
    case 'del':
        // Get values
        $confirm   = optional_param('confirm', 0, PARAM_INT);
        $id = required_param('id', PARAM_TEXT);

        // Do delete
        if (empty($confirm)) {
            if (!$client_edit = $DB->get_record('oauth_clients', array('id' => $id))) {
                echo $OUTPUT->notification(get_string('client_not_exists', 'local_edlink'));
                $view_table = true;
                break;
            }
            echo '<p>'.get_string('confirmdeletestr', 'local_edlink', $client_edit->client_id).'</p>
                <form action="index.php" method="GET">
                    <input type="hidden" name="action" value="del" />
                    <input type="hidden" name="confirm" value="1" />
                    <input type="hidden" name="id" value="'.$id.'" />
                    <input type="submit" value="'.get_string('confirm').'" /> <input type="button" value="'.get_string('cancel').'" onclick="javascript:history.back();" />
                </form>';
        } else {
            if (!$DB->delete_records('oauth_clients', array('id' => $id))) {
                print_error('delete_error', 'local_edlink');
            }
            echo $OUTPUT->notification(get_string('delok', 'local_edlink'), 'notifysuccess');
            $view_table = true;
            break;
        }
        break;
    default:
        $view_table = true;
        break;
}

if ($view_table) {
    echo '<p>';

    if (function_exists('is_agora') && is_agora()) {
        if (is_service_enabled('nodes') && !$DB->record_exists('oauth_clients', array('client_id' => 'nodes'))) {
            echo '<a href="index.php?action=addnodes" class="btn btn-primary" style="margin-right: 10px;">'.get_string('addnodesclient', 'local_edlink').'</a>';
        }
        echo '<a href="index.php?action=addwordpress" class="btn btn-primary" style="margin-right: 10px;">'.get_string('addwordpressclient', 'local_edlink').'</a>';
        echo '<a href="index.php?action=add" class="btn">'.get_string('addotherclient', 'local_edlink').'</a>';
    } else {
        echo '<a href="index.php?action=generate" class="btn">Generate Edlink API Keys</a>';
        echo '<a href="index.php?action=add" class="btn">'.get_string('addclient', 'local_edlink').'</a>';
    }

    echo '</p>';

    $clients = $DB->get_records('oauth_clients');

    if (!empty($clients)) {
        $table = new html_table();
        $table->class = 'generaltable generalbox';
        $table->head = array(
                            get_string('client_id', 'local_edlink'),
                            get_string('client_secret', 'local_edlink'),
                            get_string('grant_types', 'local_edlink'),
                            get_string('scope', 'local_edlink'),
                            get_string('user_id', 'local_edlink'),
                            get_string('actions'));
        $table->align = array('left', 'left', 'center', 'center', 'center', 'center', 'center');

        foreach ($clients as $client) {
            $row = array();
            $row[] = $client->client_id;
            $row[] = $client->client_secret;
            $row[] = $client->grant_types;
            $row[] = $client->scope;
            $row[] = $client->user_id;
            $row[] = "<a href=\"index.php?action=edit&id=".$client->id."\">".get_string('edit')."</a> | <a href=\"index.php?action=del&id=".$client->id."\">".get_string('delete')."</a>";
            $table->data[] = $row;
        }
        echo html_writer::table($table);
    }
}

echo $OUTPUT->footer();
