<?php

require_once __DIR__.'/request.php';
require_once '../../../course/externallib.php';

$context = context_system::instance();

//Pagination parameters.
$page = optional_param('page', 0, PARAM_INT);
$limit = optional_param('limit', 100, PARAM_INT);
$groupconcat = $DB->sql_group_concat('r.shortname', ',');

//Retrieve the requested users.
$sql = "SELECT
    u.id,
    u.deleted,
    u.suspended,
    u.username,
    u.idnumber,
    u.firstname,
    u.middlename,
    u.lastname,
    u.email,
    u.phone1,
    u.institution,
    u.department,
    u.address,
    u.city,
    u.country,
    u.lang,
    u.timezone,
    u.picture,
    u.auth,
    COALESCE($groupconcat, '') AS roles
    FROM {user} u
    LEFT JOIN (
      SELECT DISTINCT
        ra.userid,
        r.shortname
      FROM {role_assignments} ra
      left JOIN {role} r ON r.id = ra.roleid
    ) r ON r.userid = u.id
    GROUP BY u.id";

$users = $DB->get_records_sql($sql);
$response->setParameter('data', $users);
$response->send();
