<?php

require_once __DIR__.'/request.php';

require_once($CFG->libdir . '/externallib.php');

$user = $DB->get_record('user', array('id'=>$token['user_id']));

$systemcontext = context_system::instance();

if (!$user) {
    $logparams = array('other' => array('cause' => 'user_not_found'));
    $event = \local_edlink\event\user_info_request_failed::create($logparams);
    $event->trigger();

    $response->setStatusCode(404);
    $response->send();
    die();
}

if (isguestuser($user)) {
    throw new moodle_exception('noguest');
}

if (empty($user->confirmed)) {
    throw new moodle_exception('usernotconfirmed', 'moodle', '', $user->username);
}

// setup user session to check capability
\core\session\manager::set_user($user);

//check if the service exists and is enabled
$service = $DB->get_record('external_services', array('shortname' => 'moodle_mobile_app', 'enabled' => 1));

if (empty($service)) {
    // will throw exception if no token found
    throw new moodle_exception('servicenotavailable', 'webservice');
}

// Get an existing token or create a new one.
$token = external_generate_token_for_current_user($service);

external_log_token_request($token);

$siteadmin = is_siteadmin();

$response->setParameter('user', $user);
$response->setParameter('token', $token);
$response->setParameter('siteadmin', $siteadmin);
$response->send();