<?php

require_once '../../../config.php';
require_once __DIR__.'/../lib.php';

\core\session\manager::write_close();

$server = oauth_get_server();
$request = OAuth2\Request::createFromGlobals();
$response = new OAuth2\Response();

if (!$server->verifyResourceRequest(OAuth2\Request::createFromGlobals())) {
    $logparams = array('other' => array('cause' => 'invalid_approval'));
    $event = \local_edlink\event\user_info_request_failed::create($logparams);
    $event->trigger();

    $server->getResponse()->send();
    die();
}

$token = $server->getAccessTokenData(OAuth2\Request::createFromGlobals());

if (!isset($token['user_id']) || empty($token['user_id'])) {
    $logparams = array('other' => array('cause' => 'invalid_token'));
    $event = \local_edlink\event\user_info_request_failed::create($logparams);
    $event->trigger();

    $server->getResponse()->send();
    die();
}

$user = $DB->get_record('user', array('id' => $token['user_id']));

if (!$user) {
    $logparams = array('other' => array('cause' => 'user_not_found'));
    $event = \local_edlink\event\user_info_request_failed::create($logparams);
    $event->trigger();

    $response->setStatusCode(404);
    $response->send();
    die();
}

\core\session\manager::set_user($user);