<?php

require_once __DIR__.'/request.php';

// Import config so that we can access the `CONTEXT_COURSE` constant
require_once('../../../config.php');

$context = context_system::instance();

//Pagination parameters.
$page = optional_param('page', 0, PARAM_INT);
$limit = optional_param('limit', 100, PARAM_INT);

//Retrieve the requested user enrollments.
$sql = "SELECT
            CONCAT(ue.id, '-', ra.id) AS id,
            ue.id AS enrollment_id,
            ue.userid AS user_id,
            e.courseid AS course_id,
            ue.status AS status,
            ue.timestart AS timestart,
            ue.timeend AS timeend,
            ra.id AS role_assignment_id,
            r.id AS role_id,
            r.shortname AS role_shortname,
            r.archetype AS role_archetype,
            ra.timemodified
        FROM {user_enrolments} ue
        INNER JOIN {enrol} e
          ON e.id = ue.enrolid
        INNER JOIN {context} cx
          ON cx.contextlevel = :coursecontext AND cx.instanceid = e.courseid
        INNER JOIN {role_assignments} ra
          ON ra.userid = ue.userid AND ra.contextid = cx.id
        INNER JOIN {role} r
          ON r.id = ra.roleid
        ORDER BY ue.id ASC, ra.id ASC";

$params = ['coursecontext' => CONTEXT_COURSE];
$enrollments = $DB->get_records_sql($sql, $params, $limit * $page, $limit);

$response->setParameter('data', $enrollments);
$response->send();
