<?php

global $DB, $CFG;

require_once __DIR__.'/request.php';

require_once('../../../config.php');
require_once($CFG->dirroot . '/course/modlib.php');
require_once($CFG->dirroot . '/course/lib.php');
require_once($CFG->dirroot . '/mod/assign/lib.php');
require_once($CFG->dirroot . '/mod/assign/locallib.php');
require_once($CFG->libdir . '/filelib.php');
require_once($CFG->libdir . '/gradelib.php');
require_once($CFG->libdir . '/completionlib.php');
require_once($CFG->libdir . '/plagiarismlib.php');
require_once($CFG->dirroot . '/course/modlib.php');

// https://github.com/totara/moodle/blob/dda862abb57f656633f0736b858f7f048efd44bb/lib/sessionlib.php#L68
// Kept older version of plugin: disables sesskey check:
$USER->ignoresesskey = true;

// PARAM_* enum doc: https://wimski.org/api/3.9/d9/d0f/moodlelib_8php.html

//Pagination parameters:
$page = optional_param('page', 0, PARAM_INT);
$limit = optional_param('limit', 100, PARAM_INT);

//course and action parameters:
$courseid = required_param('course', PARAM_INT);
$add = optional_param('add', 0, PARAM_INT);
$update = optional_param('update', 0, PARAM_INT);
$delete = optional_param('delete', 0, PARAM_INT);
$action = null;
$error = null;
$assignment_deleted = false;

try {
    $context = context_course::instance($courseid);
    $course = $DB->get_record('course', array('id' => $courseid), '*', MUST_EXIST);
    require_login($course);

    if ($add == 1) {
        $action = 'adding';
        // Assignment parameters:
        $name = required_param('name', PARAM_TEXT);
        $intro = optional_param('intro', '', PARAM_CLEANHTML);
        $activity = optional_param('activity', '', PARAM_CLEANHTML);
        $cutoffdate = optional_param('cutoffdate', 0, PARAM_INT);
        $duedate = optional_param('duedate', 0, PARAM_INT);
        $allowsubmissionsfromdate = optional_param('allowsubmissionsfromdate', 0, PARAM_INT);
        $maxattempts = optional_param('maxattempts', 1, PARAM_INT);
        $grade = optional_param('grade', 100, PARAM_INT);
        $assignsubmission_file_enabled = optional_param('assignsubmission_file_enabled', 1, PARAM_INT);
        $assignsubmission_onlinetext_enabled = optional_param('assignsubmission_onlinetext_enabled', 1, PARAM_INT);

        // Create assignment object:
        $assignment = new stdClass();
        $assignment->course = $courseid;
        $assignment->name = $name;
        $assignment->modulename = 'assign';
        $assignment->module = 1;
        $assignment->visible = 1;
        $assignment->section = 0;
        $assignment->intro = $intro;
        /*
        1. **1 – Moodle Auto-format:** 
        - This is the default format that allows Moodle to automatically determine the best way to render the content based on its content type. It is generally used for content that might include both plain text and HTML.

        2. **0 – Plain text:** 
        - This format indicates that the content should be treated as plain text without any HTML or special formatting. No automatic line breaks or styling will be applied.

        3. **2 – HTML format:** 
        - This format allows the use of HTML tags, and the content will be rendered as HTML. It is useful for rich-text content that includes styling, links, lists, and other HTML-based components.

        4. **4 – Markdown:** 
        - This format allows the use of Markdown syntax within the content. Markdown is a lightweight markup language with plain-text-formatting syntax, which allows you to style text as HTML.

        5. **5 – Moodle Wiki format:** 
        - This format is used for content that should be interpreted with Moodle's wiki-like syntax, useful in contexts where content should be dynamically formatted using Moodle's internal wiki parser.
        */
        $assignment->introformat = 1;

        $assignment->cutoffdate = $cutoffdate;
        $assignment->duedate = $duedate;
        $assignment->allowsubmissionsfromdate = $allowsubmissionsfromdate;

        $assignment->grade = $grade;
        // TODO: implement other grading_types:
        // $assignment->grading_type = 'point';
        $assignment->gradingduedate = 0;

        // Setup max attempts:
        $assignment->submissiondrafts = 1;
        $assignment->attemptreopenmethod = 'manual';
        $assignment->maxattempts = $maxattempts;

        // Sbumission types:
        $assignment->assignsubmission_file_enabled = $assignsubmission_file_enabled;
        $assignment->assignsubmission_onlinetext_enabled = $assignsubmission_onlinetext_enabled;

        // Other assignment settings:
        $assignment->timecreated = time();
        $assignment->completionsubmit = 1;  // Completion tracking
        $assignment->alwaysshowdescription = 1;
        $assignment->requiresubmissionstatement = 0;
        $assignment->groupmode = 0;
        $assignment->teamsubmission = 0;
        $assignment->sendnotifications = 0;
        $assignment->sendlatenotifications = 0;
        $assignment->sendstudentnotifications = 1;
        $assignment->requireallteammemberssubmit = 0;
        $assignment->blindmarking = 0;
        $assignment->markingworkflow = 0;
        $assignment->markingallocation = 0;

        $created_assignment = add_moduleinfo($assignment, $course);
    } else if ($update == 1) {
        $action = 'updating';
        require_capability('moodle/course:manageactivities', $context);

        // Load the course and assignment modules based on the requested assignmentid:
        $assignmentid = required_param('assignment', PARAM_INT);
        $updated_assignment = $DB->get_record('assign', array('id' => $assignmentid), '*', MUST_EXIST);
        $cm = get_coursemodule_from_instance('assign', $assignmentid, $courseid);

        // Online text submission setting:
        $dbparams = array(
            'assignment'=> $assignmentid,
            'subtype'=>'assignsubmission',  
            'plugin'=>'onlinetext',
            'name'=>'enabled'
        );
        $text_submission_settings = $DB->get_record('assign_plugin_config', $dbparams, '*', IGNORE_MISSING);
        $assignsubmission_onlinetext_enabled = optional_param('assignsubmission_onlinetext_enabled', null, PARAM_TEXT);
        if ($text_submission_settings && !is_null($assignsubmission_onlinetext_enabled)) {
            $text_submission_settings->value = $assignsubmission_onlinetext_enabled;
            $DB->update_record('assign_plugin_config', $text_submission_settings);
            $updated_assignment->assignsubmission_onlinetext_enabled = $assignsubmission_onlinetext_enabled;
        } else {
            $updated_assignment->assignsubmission_onlinetext_enabled = $text_submission_settings->value;
        }

        // File submission setting:
        $dbparams = array(
            'assignment'=> $assignmentid,
            'subtype'=>'assignsubmission',  
            'plugin'=>'file',
            'name'=>'enabled'
        );
        $file_submission_settings = $DB->get_record('assign_plugin_config', $dbparams, '*', IGNORE_MISSING);
        $assignsubmission_file_enabled = optional_param('assignsubmission_file_enabled', null, PARAM_TEXT);
        if ($file_submission_settings && !is_null($assignsubmission_file_enabled)) {
            $file_submission_settings->value = $assignsubmission_file_enabled;
            $DB->update_record('assign_plugin_config', $file_submission_settings);
            $updated_assignment->assignsubmission_file_enabled = $assignsubmission_file_enabled;
        } else {
            $updated_assignment->assignsubmission_file_enabled = $file_submission_settings->value;
        }

        $name = optional_param('name', null, PARAM_TEXT);
        if (!is_null($name)) {
            $updated_assignment->name = $name;
        }

        $intro = optional_param('intro', null, PARAM_CLEANHTML);
        if (!is_null($intro)) {
            $updated_assignment->intro = $intro;
        }

        $cutoffdate = optional_param('cutoffdate', null, PARAM_INT);
        if (!is_null($cutoffdate)) {
            $updated_assignment->cutoffdate = $cutoffdate;
        }

        $duedate = optional_param('duedate', null, PARAM_INT);
        if (!is_null($duedate)) {
            $updated_assignment->duedate = $duedate;
        }

        $allowsubmissionsfromdate = optional_param('allowsubmissionsfromdate', null, PARAM_INT);
        if (!is_null($allowsubmissionsfromdate)) {
            $updated_assignment->allowsubmissionsfromdate = $allowsubmissionsfromdate;
        }

        $maxattempts = optional_param('maxattempts', null, PARAM_INT);
        if (!is_null($maxattempts)) {
            $updated_assignment->submissiondrafts = 1;
            $updated_assignment->attemptreopenmethod = 'manual';
            $updated_assignment->maxattempts = $maxattempts;
        }

        $grade = optional_param('grade', null, PARAM_INT);
        if (!is_null($grade)) {
            $updated_assignment->grade = $grade;
            assign_grade_item_update($updated_assignment);
        }

        $updated_assignment->timemodified = time();

        $DB->update_record('assign', $updated_assignment);
        rebuild_course_cache($courseid, true);
        $updated_assignment->cmid = $cm->id;
    } else if ($delete === 1) {
        $action = 'deleting';
        $cmid = required_param('cmid', PARAM_INT);
        course_delete_module($cmid);
        $assignment_deleted = true;
    }
} catch (Exception $e) {
    $error = array(
        'message' => $e->getMessage(),
        'code' => $e->getCode()
    );
}

if (!is_null($error)) {
    $response->setError(500, 'system_error', $error);
    $response->send();
} else {
    if (is_null($action)) {
        $response->setError(500, 'system_error', 'No action specified.');
        $response->send();
    } else {
        if (!is_null($created_assignment)) {
            $response->setParameter('data', $created_assignment);
            $response->send();
        } 
    
        if (!is_null($updated_assignment)) {
            $response->setParameter('data', $updated_assignment);
            $response->send();
        }
    
        if ($assignment_deleted) {
            $response->setParameter('data', ['assignment_deleted' => true]);
            $response->send();
        }

        $response->setError(500, 'system_error', 'Nothing happened.');
    }
}
